% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_upsit_percentile.R
\name{compute_upsit_percentile}
\alias{compute_upsit_percentile}
\title{Compute UPSIT Percentile Based on Age, Sex, and Score}
\usage{
compute_upsit_percentile(sex, age, upsit_score)
}
\arguments{
\item{sex}{Sex of the subject. Must be either "M" or "F"
A character string of either "M" or "F" is expected

\describe{
\item{Permitted values}{a character scalar, i.e., a character vector of length one}
\item{Default value}{none}
}}

\item{age}{Age of the subject in years.

\describe{
\item{Permitted values}{a numeric scalar, i.e., a numeric vector of length one}
\item{Default value}{none}
}}

\item{upsit_score}{The UPSIT ranging from 0 to 40.
Higher scores indicate better olfactory function.

\describe{
\item{Permitted values}{a numeric scalar, i.e., a numeric vector of length one}
\item{Default value}{none}
}}
}
\value{
A numeric percentile value.
The UPSIT percentile value corresponding to the input
parameters. Returns \code{NA_real_} if no matching entry is found in the
lookup table.
}
\description{
This function computes the UPSIT (University of Pennsylvania Smell
Identification Test) percentile for a given subject based on their age,
sex, and UPSIT raw score. The percentile is determined by looking up the
corresponding value in a normative reference table.
}
\details{
The function uses an internal lookup table (\code{upsit_lookup}) that contains
normative percentile data stratified by sex, age range, and UPSIT score.
The lookup table is based on published normative data.

Age ranges in the lookup table include:
\itemize{
\item 50-54 years
\item 55-59 years
\item 60-64 years
\item 65-69 years
\item 70-74 years
\item 75-79 years
\item 80+ years (no upper limit)
}

The function is designed to work efficiently in vectorized operations
within data processing pipelines (e.g., with \code{dplyr::mutate()})
}
\references{
Brumm MC, et. al., Updated Percentiles for the University of
Pennsylvania Smell Identification Test in Adults 50 Years of Age and Older.
\doi{10.1212/WNL.0000000000201463}
}
\seealso{
Other com_bds_findings: 
\code{\link{compute_centiloid}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
\section{Examples}{
\subsection{Look up for male percentile}{

A 52 years old male with upsit raw score of 25

\if{html}{\out{<div class="sourceCode r">}}\preformatted{compute_upsit_percentile(sex = "M", age = 52, upsit_score = 25)
#> [1] 5}\if{html}{\out{</div>}}}
\subsection{Look up for female percentile}{

A 81 years old female with upsit raw score of 30

\if{html}{\out{<div class="sourceCode r">}}\preformatted{compute_upsit_percentile(sex = "F", age = 81, upsit_score = 30)
#> [1] 39}\if{html}{\out{</div>}}}
\subsection{Returns NA}{

Minimal age is 50 and score of 0 and 40, return NA if no match found

\if{html}{\out{<div class="sourceCode r">}}\preformatted{compute_upsit_percentile(sex = "M", age = 45, upsit_score = 25)
#> [1] NA}\if{html}{\out{</div>}}}}

