% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_clinbenefit.R
\name{derive_param_clinbenefit}
\alias{derive_param_clinbenefit}
\title{Adds a Parameter for Clinical Benefit}
\usage{
derive_param_clinbenefit(
  dataset,
  dataset_adsl,
  filter_source,
  source_resp,
  source_pd = NULL,
  source_datasets,
  reference_date,
  ref_start_window,
  aval_fun,
  clinben_vals = c("CR", "PR", "SD", "NON-CR/NON-PD"),
  set_values_to,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset. This is the dataset to which the clinical
benefit rate parameter will be added.

The variables \code{PARAMCD}, \code{AVALC}, \code{ADT}, and those specified by the \code{subject_keys}
parameter and the \code{reference_date} parameter are expected.

After applying \code{filter_source} and/or \code{source_pd} the variable \code{ADT} and the
variables specified by \code{subject_keys} must be a unique key of the dataset.}

\item{dataset_adsl}{ADSL input dataset.

The variables specified for \code{subject_keys}is expected. For each subject of
the specified dataset a new observation is added to the input dataset. Variables
in \code{dataset_adsl} that also appear in \code{dataset} will be populated with the
appropriate subject-specific value for these new observations.}

\item{filter_source}{Filter condition in \code{dataset} that represents records
for overall disease response assessment for a subject at a given timepoint,
e.g. \code{PARAMCD == "OVR"} or \code{PARAMCD == "OVRLRESP"}.}

\item{source_resp}{A \code{date_source} object specifying the dataset, date variable,
and filter condition used to identify response status.}

\item{source_pd}{A \code{date_source} object specifying the dataset, date variable,
and filter condition used to identify disease progression.}

\item{source_datasets}{A named list of data sets is expected.

The list must contain the names provided by the \code{dataset_name} field of the
\code{date_source()} objects specified for \code{source_pd} and \code{source_resp}.}

\item{reference_date}{Name of variable representing the index date for
\code{ref_start_window}. A variable providing a date. An unquoted symbol is expected.}

\item{ref_start_window}{Integer representing number of days from \code{reference_date}
that must elapse before an evaluable non-PD assessment counts toward determining
clinical benefit.}

\item{aval_fun}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{set_values_to} instead.

Function to map character analysis value (\code{AVALC}) to numeric analysis value
(\code{AVAL})

The (first) argument of the function must expect a character vector and the
function must return a numeric vector.}

\item{clinben_vals}{A vector of response values to be considered when determining
clinical benefit.}

\item{set_values_to}{A named list returned by \code{exprs()} containing new variables
and their static value to be populated for the clinical benefit rate parameter
records, e.g. \code{exprs(PARAMCD = "CBR", PARAM = "Clinical Benefit Rate")}.}

\item{subject_keys}{A named list returned by \code{exprs()} containing variables
used to uniquely identify subjects.}
}
\value{
The input dataset with a new parameter for clinical benefit
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The \code{derive_param_clinbenefit()} function
has been deprecated in favor of \code{derive_extreme_event()}.

Adds a parameter for clinical benefit/disease control
}
\details{
Clinical benefit/disease control is first identified by looking for subjects
having response status, and then derived for subjects that have at least one
evaluable non-PD response assessment prior to first PD (Progressive Disease)
(i.e., responses inclusive of \code{CR}, \code{PR}, \code{SD}, and \code{NON-CR/NON-PD}) and after a specified
amount of time from a reference date (\code{ref_start_window}).

Note: The user input values they wish to include when determining
clinical benefit using the argument \code{clinben_vals}. The default values for this are
\code{CR}, \code{PR}, \code{SD}, and \code{NON-CR/NON-PD}, as listed above. In the below example,
eligible values be limited to \code{CR} and \code{PR}.

Example: \code{clinben_vals <- c("CR", "PR")}

\enumerate{
\item The input dataset (\code{dataset}) is restricted to the observations matching
\code{filter_source} and to observations before or at the date specified by \code{source_pd}.

\item This dataset is further restricted to include user-generated response
assessments from \code{clinben_vals} or include response assessments of \code{CR},
\code{PR}, \code{SD}, and \code{NON-CR/NON-PD}, exclude missing response assessments, and
exclude those less than \code{ref_start_window} after \code{reference_date}. The earliest
assessment by \code{ADT} is then selected.

\item The dataset identified by \code{dataset} in \code{source_resp} is restricted
according to its \code{filter} argument. The variable corresponding to the \code{date}
parameter of \code{source_resp} is considered together with \code{ADT} from the
previous step.

\item For the observations being added to \code{dataset}, \code{ADT} is set to the earlier
of the first assessment date representing an evaluable non-PD assessment prior
to first PD, or the date representing the start of response.

\item For the observations being added to \code{dataset}, \code{AVALC} is set to
\itemize{
\item \code{Y} for those subjects in the \code{dataset} meeting the criteria for clinical
benefit above
\item \code{N} for subjects not meeting the clinical benefit criteria in \code{dataset}
or the dataset identified in \code{source_resp}
\item \code{N} for subjects present in \code{dataset_adsl} but not present in \code{dataset}
or the dataset identified in \code{source_resp}.
}

\item The variables specified by \code{set_values_to} are added to the new observations
with values equal to the values specified in the same.

\item The new observations are added to \code{dataset}. Variables held in common
between \code{dataset} and \code{dataset_adsl} are kept for the new observations, and
are populated with their values from \code{dataset_adsl}.
}
}
\examples{
library(lubridate)
library(dplyr)
library(admiral)
# ensure that `date_source()` from admiralonco is used to avoid deprecation
# warning
unloadNamespace("admiralonco")
library(admiralonco)

adsl <- tibble::tribble(
  ~USUBJID, ~TRTSDT,
  "01",     ymd("2020-01-14"),
  "02",     ymd("2021-02-16"),
  "03",     ymd("2021-03-09"),
  "04",     ymd("2021-04-21")
) \%>\%
  mutate(STUDYID = "AB42")

adrs <- tibble::tribble(
  ~USUBJID, ~PARAMCD, ~AVALC, ~ADT,
  "01",     "RSP",    "Y",    ymd("2021-03-14"),
  "02",     "RSP",    "N",    ymd("2021-05-07"),
  "03",     "RSP",    "N",    NA,
  "04",     "RSP",    "N",    NA,
  "01",     "PD",     "N",    NA,
  "02",     "PD",     "Y",    ymd("2021-05-07"),
  "03",     "PD",     "N",    NA,
  "04",     "PD",     "N",    NA,
  "01",     "OVR",    "SD",   ymd("2020-03-14"),
  "01",     "OVR",    "PR",   ymd("2021-04-13"),
  "02",     "OVR",    "PR",   ymd("2021-04-08"),
  "02",     "OVR",    "PD",   ymd("2021-05-07"),
  "02",     "OVR",    "CR",   ymd("2021-06-20"),
  "03",     "OVR",    "SD",   ymd("2021-03-30"),
  "04",     "OVR",    "NE",   ymd("2021-05-21"),
  "04",     "OVR",    "NA",   ymd("2021-06-30"),
  "04",     "OVR",    "NE",   ymd("2021-07-24"),
  "04",     "OVR",    "ND",   ymd("2021-09-04"),
) \%>\%
  mutate(STUDYID = "AB42", ANL01FL = "Y") \%>\%
  derive_vars_merged(
    dataset_add = adsl,
    by_vars = exprs(STUDYID, USUBJID),
    new_vars = exprs(TRTSDT)
  )

pd <- date_source(
  dataset_name = "adrs",
  date = ADT,
  filter = PARAMCD == "PD" & AVALC == "Y" & ANL01FL == "Y"
)

resp <- date_source(
  dataset_name = "adrs",
  date = ADT,
  filter = PARAMCD == "RSP" & AVALC == "Y" & ANL01FL == "Y"
)

derive_param_clinbenefit(
  dataset = adrs,
  dataset_adsl = adsl,
  filter_source = PARAMCD == "OVR" & ANL01FL == "Y",
  source_resp = resp,
  source_pd = pd,
  source_datasets = list(adrs = adrs),
  reference_date = TRTSDT,
  ref_start_window = 28,
  set_values_to = exprs(
    PARAMCD = "CBR"
  )
) \%>\%
  filter(PARAMCD == "CBR")
}
\seealso{
Other deprecated: 
\code{\link{date_source}()},
\code{\link{derive_param_bor}()},
\code{\link{derive_param_confirmed_bor}()},
\code{\link{derive_param_confirmed_resp}()},
\code{\link{derive_param_response}()},
\code{\link{filter_pd}()}
}
\author{
Andrew Smith
}
\concept{deprecated}
\keyword{deprecated}
