% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ashape3d.R
\name{plot.ashape3d}
\alias{plot.ashape3d}
\title{Plot the \eqn{\alpha}-shape in 3D}
\usage{
\method{plot}{ashape3d}(x, clear = TRUE, col = c(2, 2, 2),
  byComponents = FALSE, indexAlpha = 1, transparency = 1,
  walpha = FALSE, triangles = TRUE, edges = TRUE, vertices = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{"ashape3d"} that represents the
\eqn{\alpha}-shape of a given sample of points in the three-dimensional
space, see \code{\link[alphashape3d]{ashape3d}}.}

\item{clear}{Logical, specifying whether the current rgl device should be
cleared.}

\item{col}{A vector of length three specifying the colors of the triangles,
edges and vertices composing the \eqn{\alpha}-shape, respectively.}

\item{byComponents}{Logical, if TRUE the connected components of the
\eqn{\alpha}-shape are represented in different colors, see
\code{\link[alphashape3d]{components_ashape3d}}.}

\item{indexAlpha}{A single value or vector with the indexes of
\code{x$alpha} that should be used for the computation, see Details.}

\item{transparency}{The coefficient of transparency, from 0 (transparent) to
1 (opaque), used to plot the \eqn{\alpha}-shape.}

\item{walpha}{Logical, if TRUE the value of \eqn{\alpha} is displayed in the
rgl device.}

\item{triangles}{Logical, if TRUE triangles are plotted.}

\item{edges}{Logical, if TRUE edges are plotted.}

\item{vertices}{Logical, if TRUE vertices are plotted.}

\item{\dots}{Material properties. See \code{\link[rgl]{material3d}} for
details.}
}
\description{
This function plots the \eqn{\alpha}-shape in 3D using the package
\code{\link[rgl]{rgl}}.
}
\details{
The function \code{plot.ashape3d} opens a rgl device for each value of
\eqn{\alpha} in \code{x$alpha[indexAlpha]}. Device information is displayed
in the console.

If \code{indexAlpha="all"} or \code{indexAlpha="ALL"} then the function
represents the \eqn{\alpha}-shape for all values of \eqn{\alpha} in
\code{as3d$alpha}.
}
\examples{

T1 <- rtorus(1000, 0.5, 2)
T2 <- rtorus(1000, 0.5, 2, ct = c(2, 0, 0), rotx = pi/2)
x <- rbind(T1, T2)
alpha <- c(0.15, 0.25, 1)
ashape3d.obj <- ashape3d(x, alpha = alpha)

# Plot the alpha-shape for all values of alpha
plot(ashape3d.obj, indexAlpha = "all")

# Plot the connected components of the alpha-shape for alpha=0.25
plot(ashape3d.obj, byComponents = TRUE, indexAlpha = 2)

}
\seealso{
\code{\link[alphashape3d]{ashape3d}}, \code{\link[alphashape3d]{components_ashape3d}}
}
