% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_gmted}
\alias{process_gmted}
\title{Process elevation data}
\usage{
process_gmted(variable = NULL, path = NULL, extent = NULL, ...)
}
\arguments{
\item{variable}{vector(1). Vector containing the GMTED statistic first and
the resolution second. (Example: variable = c("Breakline Emphasis",
"7.5 arc-seconds")).
\itemize{
\item Statistic options: "Breakline Emphasis", "Systematic Subsample",
"Median Statistic", "Minimum Statistic", "Mean Statistic",
"Maximum Statistic", "Standard Deviation Statistic"
\item Resolution options: "30 arc-seconds", "15 arc-seconds", "7.5 arc-seconds"
}}

\item{path}{character(1). Directory with downloaded GMTED  "*_grd"
folder containing .adf files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
The \code{process_gmted()} function imports and cleans raw elevation data,
returning a single \code{SpatRaster} object.
}
\note{
\code{SpatRaster} layer name indicates selected variable and resolution, and year
of release (2010).
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
gmted <- process_gmted(
  variable = c("Breakline Emphasis", "7.5 arc-seconds"),
  path = "./data/be75_grd"
)
}
}
\author{
Mitchell Manware
}
