% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection.R
\name{detect}
\alias{detect}
\title{Apply MegaDetector to a Given Batch of Images}
\usage{
detect(
  detector,
  image_file_names,
  resize_width,
  resize_height,
  letterbox = TRUE,
  confidence_threshold = 0.1,
  file_col = "filepath",
  batch_size = 1,
  num_workers = 1,
  device = NULL,
  checkpoint_path = NULL,
  checkpoint_frequency = -1
)
}
\arguments{
\item{detector}{preloaded md model}

\item{image_file_names}{list of image filenames, a single image filename, or folder}

\item{resize_width}{width to resize images to}

\item{resize_height}{height to resize images to}

\item{letterbox}{if True, resize and pad image to keep aspect ratio, else resize without padding}

\item{confidence_threshold}{only detections above this threshold are returned}

\item{file_col}{select which column if image_file_names is a manifest}

\item{batch_size}{size of each batch}

\item{num_workers}{number of processes to handle the data}

\item{device}{specify to run on cpu or gpu}

\item{checkpoint_path}{path to checkpoint file}

\item{checkpoint_frequency}{write results to checkpoint file every N images}
}
\value{
list of dictionaries of MegaDetector detections
}
\description{
Apply MegaDetector to a Given Batch of Images
}
\examples{
\dontrun{mdres <- detect(md_py, allframes$Frame, 1280, 960, device='cpu')}
}
