% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_apsimx_json.R
\name{inspect_apsimx_json}
\alias{inspect_apsimx_json}
\title{Inspect an .apsimx or .json (JSON) file}
\usage{
inspect_apsimx_json(
  file = "",
  src.dir = ".",
  parm,
  search.depth = 15,
  print.path = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{file ending in .apsimx or .json to be inspected (JSON)}

\item{src.dir}{directory containing the .apsimx or .json file to be inspected; defaults to the current working directory}

\item{parm}{string or regular expression for partial matching. It can be two strings separated by a period to search within a node (child).}

\item{search.depth}{default is 15. How deep should the algorithm explore the structure of the list.}

\item{print.path}{whether to print the parameter path (default is FALSE)}

\item{verbose}{whether to print additional information (mostly used for debugging)}
}
\value{
prints a table with inspected parameters and values (and the path when \sQuote{print.path} = TRUE).
}
\description{
inspect an .apsimx or .json (JSON) file. It does not replace the GUI, but it can save time by quickly checking parameters and values.
}
\details{
This function is a work in progress. There are many instances for which it will not work.

 It will probably only find the first instance that matches.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
## It seems to work for simple search
inspect_apsimx_json("Wheat.apsimx", src.dir = extd.dir, parm = "Version")
inspect_apsimx_json("Wheat.apsimx", src.dir = extd.dir, parm = "Simulations")
inspect_apsimx_json("Wheat.apsimx", src.dir = extd.dir, parm = "Clock")
inspect_apsimx_json("Wheat.apsimx", src.dir = extd.dir, parm = "Weather")
## Does return soil components
inspect_apsimx_json("Wheat.apsimx", src.dir = extd.dir, parm = "DUL")
## Or cultivar
inspect_apsimx_json("Wheat.apsimx", src.dir = extd.dir, parm = "Hartog")

}
}
