% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqp-label-placement-solvers.R
\name{fixOverlap}
\alias{fixOverlap}
\title{Fix Overlap within a Sequence}
\usage{
fixOverlap(x, thresh = 0.6, method = c("S", "E"), trace = FALSE, ...)
}
\arguments{
\item{x}{vector of initial positions, pre-sorted}

\item{thresh}{numeric, overlap threshold defined on the same scale as \code{x}}

\item{method}{character vector, 'S' for simulated annealing via \code{\link[=SANN_1D]{SANN_1D()}} or 'E' for electrostatic simulation via \code{\link[=electroStatics_1D]{electroStatics_1D()}}}

\item{trace}{logical, return full output}

\item{\dots}{additional arguments to \code{\link[=SANN_1D]{SANN_1D()}} or \code{\link[=electroStatics_1D]{electroStatics_1D()}}}
}
\value{
When \code{trace = FALSE}, a vector of the same length as \code{x}, preserving rank-ordering and boundary conditions. When \code{trace = TRUE} a list containing the new sequence along with information about objective functions and decisions made during adjustment of \code{x}.
}
\description{
Fix Overlap within a Sequence
}
\examples{

s <- c(1, 2, 2.3, 4, 5, 5, 7)

# simulated annealing, solution is non-deterministic
fixOverlap(s, thresh = 0.6, method = 'S')

# electrostatics-inspired simulation of particles
# solution is deterministic
fixOverlap(s, thresh = 0.6, method = 'E')


# create a very busy profile with lots of possible overlapping
# depth annotation
x <- quickSPC(
  "SPC:AAA|BBB|CCC|D|EEEEE|FF|GG|HH|I|I|JJ|KK|LL|M|N|O|P|QQQQ|RR|S|TTTTTT|U", 
  interval = 1
)

# convert horizon ID to numeric
x$z <- as.numeric(x$hzID)

# plotSPC arguments
.a <- list(
  width = 0.2, 
  hz.depths = TRUE, 
  name.style = 'center-center', 
  cex.names = 1.5, 
  depth.axis = FALSE, 
  name = NA,
  color = 'z',
  show.legend = FALSE,
  print.id = FALSE,
  col.palette = hcl.colors(n = 25, palette = 'Spectral', rev = TRUE)
)

# set plotSPC default arguments
options(.aqp.plotSPC.args = .a)

# wrapper function to test label collision solutions
testIt <- function(x, ...) {
  
  plotSPC(x, ...)
  
  # a normalized index of label adjustment
  .txt <- sprintf(
    "LAI: \%0.3f", 
    get('last_spc_plot', envir = aqp.env)$hz.depth.LAI
  )
  mtext(.txt, side = 1, at = 1, line = -2, cex = 0.8)
  
}


# compare and contrast
op <- par(mar = c(0, 0, 0, 0), mfcol = c(1, 6))

testIt(x)
title('ES (defaults)', line = -3)

testIt(x, fixOverlapArgs = list(method = 'S'))
title('SANN (defaults)', line = -3)

testIt(x, fixOverlapArgs = list(method = 'E', q = 1.5))
title('ES (q = 1.5)', line = -3)

testIt(x, fixOverlapArgs = list(method = 'E', q = 1))
title('ES (q = 1)', line = -3)

testIt(x, fixOverlapArgs = list(method = 'E', q = 0.5))
title('ES (q = 0.5)', line = -3)

testIt(x, fixOverlapArgs = list(method = 'E', q = 0.1))
title('ES (q = 0.1)', line = -3)

par(op)

}
\seealso{
\code{\link[=electroStatics_1D]{electroStatics_1D()}}, \code{\link[=SANN_1D]{SANN_1D()}}
}
