% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{samplings}
\alias{samplings}
\title{Sampling data}
\format{
A tibble with 181 rows and 14 columns:
\describe{
 \item{date}{date; date of data recording.}
 \item{tank}{factor; rearing tank identifier.}
 \item{replicate}{factor; replicate identifier.}
 \item{sample_type}{factor; type of sample.}
 \item{fish_weight}{numeric; weight of fish in gram.}
 \item{fork_length}{numeric; length of fish from the tip of the snout to the 
 end of the middle caudal fin rays in centimeter.}
 \item{liver_weight}{numeric; weight of the liver in gram.}
 \item{hsi}{numeric; hepatosomatic index in percent.}
 \item{heart_weight}{numeric; weight of the heart in gram.}
 \item{csi}{numeric; cardiosomatic index in percent.}
 \item{gonad_weight}{numeric; weight of the gonads in gram.}
 \item{gsi}{numeric; gonadosomatic index in percent.}
 \item{viscera_weight}{numeric; weight of the viscera in gram.}
 \item{vsi}{numeric; viscerosomatic index in percent.}
}
}
\description{
This dataset contains the fish weight, fork length, sex, liver weight, 
hepatosomatic index, heart weight, cardiosomatic index, gonad weight, 
gonadosomatic index, viscera weight, and viscerosomatic index from a 
feeding trial with Atlantic salmon (Salmo salar).
The original dataset ('FeedIntake') was published by Liland et al. (2024)
and is from the first out of two trials ('Trial A'). Alterations to the 
original data structure were done by 1) converting the double-row column 
names into single-row column names, and 2) removing the 'sex' column.
}
\examples{
samplings

}
\references{
Liland, N., Rønnestad, I., Azevedo, M., Lai, F., Oulie, F., 
Conceição, L., Soares, F. (2024): Dataset on the performance of Atlantic 
salmon (Salmo salar) reared at different dissolved oxygen levels under 
experimental conditions. Data in Brief 57, 110983. 
https://doi.org/10.1016/j.dib.2024.110983
}
\keyword{datasets}
