% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{water_params}
\alias{water_params}
\title{Daily water parameters}
\format{
A tibble with 270 rows and 6 columns:
\describe{
 \item{date}{date; date of data recording.}
 \item{tank}{factor; rearing tank identifier.}
 \item{temp}{numeric; water temperature in degrees Celsius.}
 \item{salinity}{numeric; salinity in parts per thousand.}
 \item{do_perc}{numeric; dissolved oxygen in percentage saturation.}
 \item{do_conc}{numeric; dissolved oxygen concentration in mg/L.}
}
}
\description{
This dataset contains daily readings of water temperature, salinity, and 
dissolved oxygen from a feeding trial with Atlantic salmon (Salmo salar).
The original dataset ("WaterParametersDaily") was published by
Liland et al. (2024) and is from the first out of two trials 
("Trial A"). Alterations to the original data structure were done by 
1) converting the double-row column names into single-row column names,
2) shortening the column names, and 3) converting the table into long 
format by moving the tank IDs into a separate column.
}
\examples{
water_params

}
\references{
Liland, N., Rønnestad, I., Azevedo, M., Lai, F., Oulie, F., 
Conceição, L., Soares, F. (2024): Dataset on the performance of Atlantic 
salmon (Salmo salar) reared at different dissolved oxygen levels under 
experimental conditions. Data in Brief 57, 110983. 
https://doi.org/10.1016/j.dib.2024.110983
}
\keyword{datasets}
