% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-bbox.R
\name{auk_extent}
\alias{auk_extent}
\title{Filter the eBird data by spatial extent}
\usage{
auk_extent(x, extent)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{extent}{numeric; spatial extent expressed as the range of latitudes and
longitudes in decimal degrees: \code{c(lng_min, lat_min, lng_max, lat_max)}.
Note that longitudes in the Western Hemisphere and latitudes sound of the
equator should be given as negative numbers.}
}
\value{
An \code{auk_ebd} object.
}
\description{
\strong{Deprecated}, use \code{\link[=auk_bbox]{auk_bbox()}} instead.
}
\examples{
# fliter to locations roughly in the Pacific Northwest
system.file("extdata/ebd-sample.txt", package = "auk") |>
  auk_ebd() |>
  auk_bbox(bbox = c(-125, 37, -120, 52))
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_bbox(ebd, bbox = c(-125, 37, -120, 52))
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_exotic}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
