% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_output.R
\name{save_outputs}
\alias{save_outputs}
\title{Save a list of outputs}
\usage{
save_outputs(
  outputs,
  outfolder = file.path("output"),
  generic_suffix = NULL,
  save_rds = TRUE,
  verbose_level = 1
)
}
\arguments{
\item{outputs}{`list` of outputs as created by `generate_outputs`}

\item{outfolder}{Folder in which to store the `outputs``}

\item{generic_suffix}{generic suffix. must be length 1 character or NULL.}

\item{save_rds}{Should the input `outputs` be saved as `.rds` files in
in addition to `.out` or `.pdf` files? Defaults to `FALSE`.}

\item{verbose_level}{Level of verbose information displayed.
Default set to `1`.}
}
\value{
The input `object` invisibly
}
\description{
Save a list of outputs
}
\examples{
\dontshow{if (require(filters)) withAutoprint(\{ # examplesIf}
## As `save_outputs` is the last step in the pipeline we have to run
## the 'whole machinery' in order to show its functionality.
library(dplyr, warn.conflicts = FALSE)

data <- list(
  adsl = eg_adsl,
  adae = eg_adae,
  adtte = eg_adtte
)

filters::load_filters(
  yaml_file = system.file("filters.yml", package = "autoslider.core"),
  overwrite = TRUE
)

## For this example the outputs will be saved in a temporary directory. In a
## production run this should be the reporting event's 'output' folder instead.
output_dir <- tempdir()

spec_file <- system.file("spec.yml", package = "autoslider.core")
read_spec(spec_file) \%>\%
  filter_spec(program == "t_dm_slide") \%>\%
  generate_outputs(datasets = data) \%>\%
  decorate_outputs() \%>\%
  save_outputs(outfolder = output_dir)
\dontshow{\}) # examplesIf}
}
