% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_clusters.R
\name{bam_clusters}
\alias{bam_clusters}
\title{bam_clusters: Function to estimate the connectivity of suitable areas}
\usage{
bam_clusters(model, ngbs = 1, set_M = NULL, plot_model = FALSE)
}
\arguments{
\item{model}{A niche model in raster format or a \code{\link[bamm]{setA}}
object (see \code{\link[bamm]{model2sparse}}).}

\item{ngbs}{Numeric. Number of neighbors (see details).}

\item{set_M}{A setM object containing the adjacency matrix of the
study area. The default value is set to NULL}

\item{plot_model}{Logical. Indicates whether to plot the niche model using a
leaflet map, connected suitable cells shown in the same color.}
}
\value{
An object of class \code{\link[bamm]{csd}}. It contains three slots.
1) connections: a data.frame with three columns where first and the second
represent (x and y) centroid coordinates of the niche model
and the third column with the cluster ID where they belong.
2) interactive_map: a leaflet map of connected suitable pixels shown in
the same color. 3) A RasterLayer of connected suitable pixels.
}
\description{
Function to estimate the connectivity of suitable areas given
an adjacency matrix.
}
\details{
The main result of the function is the Connectivity-Suitability-Diagram
(CSD). In this diagram connected suitable cells make clusters of pixels.
For more details about the CSD see (Soberon and Osorio-Olvera, 2022).
}
\examples{
set.seed(891)
model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)
model <- model > 0.7
clusterin <- bamm::bam_clusters(model,ngbs=1,plot_model=TRUE)
raster::plot(clusterin@raster_map)
\donttest{
clusterin@interactive_map
}
}
\references{
\insertRef{SoberonOsorio}{bamm}.
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
