% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_reporting_triangle.R
\name{as_reporting_triangle.data.frame}
\alias{as_reporting_triangle.data.frame}
\title{Create a \code{reporting_triangle} object from a data.frame}
\usage{
\method{as_reporting_triangle}{data.frame}(
  data,
  delays_unit = "days",
  reference_date = "reference_date",
  report_date = "report_date",
  count = "count",
  ...
)
}
\arguments{
\item{data}{Data.frame in a long tidy format with counts by reference date
and report date. Must contain the following columns:
.    - Column of type \code{date} or character with the dates of
the primary event occurrence (reference date).
\itemize{
\item Column of type \code{date} or character with the dates of
report of the primary event (report_date).
\item Column of numeric or integer indicating the new confirmed counts
pertaining to that reference and report date (count).
Additional columns can be included but will not be used. The input
dataframe for this function must contain only a single strata, there can
be no repeated reference dates and report dates.
}}

\item{delays_unit}{Character string specifying the temporal granularity of
the delays. Options are \code{"days"}, \code{"weeks"}, \code{"months"}, \code{"years"}.
Default is \code{"days"}.}

\item{reference_date}{Character string indicating the name of the
column which represents the reference date, or the date of the primary
event occurrence.}

\item{report_date}{Character string indicating the name of the
column which represents the date the primary event was reported.}

\item{count}{Character string indicating the name of the column
containing the number of incident cases on each reference and report date.}

\item{...}{Additional arguments not used.}
}
\value{
A \code{\link{reporting_triangle}} object
}
\description{
This method takes a data.frame containing case counts indexed by reference
date and report date and creates a \link{reporting_triangle} object.
See \code{\link[=as_reporting_triangle.matrix]{as_reporting_triangle.matrix()}} for other data
input options.
}
\examples{
# Filter to reasonable max_delay for faster example
data_as_of_df <- syn_nssp_df[
  syn_nssp_df$report_date <= "2026-04-01" &
    (syn_nssp_df$report_date - syn_nssp_df$reference_date) <= 25,
]
as_reporting_triangle(data = data_as_of_df)
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
