% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_reporting_triangle}
\alias{example_reporting_triangle}
\title{Simple example reporting triangle for demonstrations}
\format{
A \link{reporting_triangle} object with 5 reference dates and 4 delays:
\describe{
\item{reporting_triangle_matrix}{5x4 matrix with counts}
\item{reference_dates}{5 dates starting from 2024-01-01}
\item{delays_unit}{"days"}
}
}
\usage{
example_reporting_triangle
}
\description{
A basic \link{reporting_triangle} object demonstrating standard
structure with complete early reference times and progressively incomplete
recent times. Useful for simple examples and tests.
}
\details{
This is a simple, clean example without complications like negative values
or unusual structures. Ideal for:
\itemize{
\item Package examples demonstrating basic functionality
\item Unit tests for standard cases
\item Vignettes introducing nowcasting concepts
}

Use \link{example_downward_corr_rt} for examples with data quality corrections.
}
\examples{
# View the example triangle
example_reporting_triangle

# Use in nowcasting - requires complete rows for delay estimation
estimate_delay(example_reporting_triangle, n = 6)
}
\seealso{
\itemize{
\item \link{example_downward_corr_rt} for downward corrections example
\item \code{\link[=as_reporting_triangle]{as_reporting_triangle()}} to create reporting triangles
}

Example datasets
\code{\link{example_downward_corr_rt}},
\code{\link{germany_covid19_hosp}},
\code{\link{syn_nssp_df}},
\code{\link{syn_nssp_line_list}}
}
\concept{example_data}
\keyword{datasets}
