% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_ext}
\alias{read_ext}
\title{Read GDAL vector data}
\usage{
read_ext(x, ext = NULL, ...)
}
\arguments{
\item{x}{used as `sf::st_read()`` dsn argument}

\item{ext}{optional extent (as per raster package)}

\item{...}{arguments passed to `sf::st_read()`}
}
\value{
sf object, see `sf::st_read()`
}
\description{
Read vector shape data with optional extent filter.
}
\details{
The extent coordinates must be in the same projection as the source, or the result could be wrong.

Uses the 'sf' package to pass the extent down to GDAL's ExecuteSQL as WKT, use anything with
an extent that the 'raster' package understands.
}
\examples{
\dontrun{
\donttest{
# read_ext("myshapefile", raster::extent(100, 120, -40, -30))
}
}
}
