% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_variance.R
\name{bayes_variance}
\alias{bayes_variance}
\title{Calculate the variance of a probability cube}
\usage{
bayes_variance(x, window_size = 9, neigh_fraction = 0.5)
}
\arguments{
\item{x}{SpatRaster object containing probabilities.}

\item{window_size}{Size of the neighborhood.}

\item{neigh_fraction}{Fraction of neighbors with highest probability
to be used in Bayesian inference.}
}
\value{
A variance SpatRaster object.
}
\description{
Takes a probability cube and estimate the local variance
             of the logit of the probability,
             to support the choice of parameters for Bayesian smoothing.
}
\examples{
if (bayes_run_examples()) {
    # select a file with probability values
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # create a SpatRaster object from the file
    x <- terra::rast(paste0(data_dir, "/", file))
    # provide the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # name the layers in the SpatRaster with the labels
    names(x) <- labels
    # calculate the variance
    v <- bayes_variance(x)
    # plot the variance
    bayes_plot_var(v, quantile = 0.75)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
