% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frac_bayes_factors.R
\name{frac_bayes_factors}
\alias{frac_bayes_factors}
\title{Fractional Bayes factors}
\usage{
frac_bayes_factors(object1, object2, fractional_proportion)
}
\arguments{
\item{object1}{object of class \code{lm_b}}

\item{object2}{object of class \code{lm_b}}

\item{fractional_proportion}{The fraction of the data used to create the
prior in turn used to compute the marginal likelihood.  By default,
O'Hagan's recommendation of \eqn{max(log(n),ncol(X) + 1) / n)} is used.}
}
\description{
Compute fractional Bayes factors for lm_b objects
}
\details{
Fractional Bayes factors, devised by O'Hagan, are a way to use flat,
even improper, priors to obtain valid Bayes factors.  The idea is built
on the notion of partial Bayes factors, where a part of the data is used
to determine the prior, and the remaining is used to compare the models.
}
\examples{
\donttest{
set.seed(2026)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit_full <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
fit_no_x1 <-
  lm_b(outcome ~ x2 + x3,
       data = test_data)
fit_no_x2 <-
  lm_b(outcome ~ x1 + x3,
       data = test_data)

frac_bayes_factors(fit_full,
                   fit_no_x1)
frac_bayes_factors(fit_full,
                   fit_no_x2)

}


}
\references{
O’Hagan, Anthony. “Fractional Bayes Factors for Model Comparison.” Journal of the Royal Statistical Society. Series B (Methodological), vol. 57, no. 1, 1995, pp. 99–138. https://doi.org/10.1111/j.2517-6161.1995.tb02017.x
}
