% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{apply_inv_link}
\alias{apply_inv_link}
\title{Apply the inverse-link function to a linear predictor}
\usage{
apply_inv_link(eta, link)
}
\arguments{
\item{eta}{Numeric vector or scalar — the linear predictor
\eqn{\eta = X \beta}.}

\item{link}{Character string naming the link function. Supported
values: \code{"logit"}, \code{"probit"}, \code{"cauchit"},
\code{"cloglog"}, \code{"log"}, \code{"sqrt"}, \code{"1/mu^2"},
\code{"inverse"}, \code{"identity"}.}
}
\value{
Numeric vector (or scalar) of the same length as \code{eta},
  containing \eqn{g^{-1}(\eta)}.
}
\description{
Evaluates the inverse of a standard link function for a given
linear-predictor vector or scalar. This is a convenience wrapper
around \code{\link[stats]{make.link}}.
}
\keyword{internal}
