% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-brsmm.R
\name{autoplot.brsmm}
\alias{autoplot.brsmm}
\title{ggplot2 autoplot for brsmm models}
\usage{
\method{autoplot}{brsmm}(
  object,
  type = c("calibration", "score_dist", "ranef_qq", "residuals_by_group",
    "ranef_caterpillar", "ranef_density", "ranef_pairs"),
  bins = 10L,
  scores = NULL,
  residual_type = c("response", "pearson"),
  max_groups = 25L,
  ...
)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{type}{Plot type:
\code{"calibration"}, \code{"score_dist"}, \code{"ranef_qq"}, or
\code{"residuals_by_group"}, \code{"ranef_caterpillar"},
\code{"ranef_density"}, \code{"ranef_pairs"}.}

\item{bins}{Number of bins used in calibration plots.}

\item{scores}{Optional integer vector of scores for \code{"score_dist"}.
Defaults to all scores from \code{0} to \code{ncuts}.}

\item{residual_type}{Residual type passed to \code{\link{residuals.brsmm}}
for \code{type = "residuals_by_group"}.}

\item{max_groups}{Maximum number of groups displayed in
\code{"residuals_by_group"}.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot2} object.
}
\description{
Produces ggplot2 diagnostics tailored to mixed beta interval models.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit_mm <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
ggplot2::autoplot(fit_mm, type = "calibration", bins = 4)
ggplot2::autoplot(fit_mm, type = "score_dist")
ggplot2::autoplot(fit_mm, type = "ranef_qq")
ggplot2::autoplot(fit_mm, type = "ranef_caterpillar")
ggplot2::autoplot(fit_mm, type = "ranef_density")
}

}
