% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{residuals.brsmm}
\alias{residuals.brsmm}
\title{Residuals from a brsmm model}
\usage{
\method{residuals}{brsmm}(
  object,
  type = c("response", "pearson", "deviance", "rqr", "weighted", "sweighted"),
  ...
)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{type}{Character: \code{"response"} (default), \code{"pearson"},
\code{"deviance"}, \code{"rqr"}, \code{"weighted"}, or \code{"sweighted"}.}

\item{...}{Currently ignored.}
}
\value{
Numeric vector.
}
\description{
Residuals from a brsmm model
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
head(residuals(fit))
head(residuals(fit, type = "pearson"))
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{fitted.brsmm}},
  \code{\link{plot.brsmm}}
}
