% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R
\name{encode}
\alias{encode}
\alias{encode.character}
\title{Encode a string into a BIDS key-value list}
\usage{
encode(x, ...)

\method{encode}{character}(x, ...)
}
\arguments{
\item{x}{The filename string to encode}

\item{...}{Additional arguments passed to methods}
}
\value{
A list of key-value pairs extracted from the filename
}
\description{
This function parses a BIDS filename and extracts its components into a key-value list.
It understands standard BIDS entities like subject, session, task, run, etc.
}
\examples{
# Encode an anatomical file
encode("sub-01_T1w.nii.gz")

# Encode a functional file
encode("sub-01_task-rest_run-01_bold.nii.gz")

# Encode a file with session information
encode("sub-01_ses-pre_task-rest_run-01_bold.nii.gz")
}
