% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{file_pairs}
\alias{file_pairs}
\title{Find File Pairs in a BIDS Project}
\usage{
file_pairs(
  x,
  pair = c("bold-events", "preproc-events"),
  task = ".*",
  matchon = c("run", "task"),
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{pair}{A character string specifying which pair of files to match. Currently supported:
\itemize{
\item "bold-events": matches BOLD files with event files
\item "preproc-events": matches preprocessed BOLD files with event files
}}

\item{task}{A regex pattern to filter tasks. Default is ".*" (no filter).}

\item{matchon}{A character vector of keys to match on, usually c("run", "task").}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A tibble with columns:
\itemize{
\item \code{subid}: The subject ID
\item \code{task}: The task name
\item \verb{[type1]}: The name of the first file type (e.g., "bold" or "preproc")
\item \verb{[type2]}: The matched file of the second type (e.g., "events"), or \code{NA} if no match found
\item Additional columns for matched metadata (e.g., run, session)
}
}
\description{
This function matches pairs of related files (e.g., BOLD and event files) in a BIDS project,
returning a tibble with matched filenames. It's useful for verifying that corresponding files
exist for each subject and task, such as ensuring every BOLD file has an associated events file.
}
\examples{
\donttest{
# Create a BIDS project object
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  
  # Match BOLD files with their corresponding event files
  bold_pairs <- file_pairs(proj, pair="bold-events")
  
  # Check pairs for a specific task
  task_pairs <- file_pairs(proj, 
                          pair="bold-events",
                          task="balloonanalogrisktask")
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}

}
