% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_bids.R
\name{sessions.mock_bids_project}
\alias{sessions.mock_bids_project}
\title{Get Sessions from Mock BIDS Project}
\usage{
\method{sessions}{mock_bids_project}(x, ...)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{...}{Extra arguments (ignored).}
}
\value{
Character vector of unique session IDs (e.g., c("pre", "post")), sorted,
or \code{NULL} if the project does not have sessions.
}
\description{
Extracts the unique session IDs found in the mock project's file structure.
Note: Returns IDs \emph{without} the "ses-" prefix.
}
\examples{
# Create a mock project with sessions
parts <- data.frame(participant_id = "01")
fs <- data.frame(subid="01", session="test", datatype="func", suffix="bold.nii.gz", fmriprep=FALSE)
mock_proj <- create_mock_bids("SessionMock", parts, fs)

# Get session IDs
sessions(mock_proj)

# Project without sessions
fs_no_session <- data.frame(subid="01", datatype="func", suffix="bold.nii.gz", fmriprep=FALSE)
mock_proj_no_sess <- create_mock_bids("NoSessionMock", parts, fs_no_session)
sessions(mock_proj_no_sess) # Returns NULL
}
