% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigalgebra.R
\name{dadd}
\alias{dadd}
\title{Add two double-precision vectors.}
\usage{
dadd(N = NULL, X, INCX = 1L, Y, INCY = 1L)
}
\arguments{
\item{N}{number of elements in the input vectors. Defaults to the length of \code{X} if \code{NULL}.}

\item{X}{double precision vector or matrix providing the addend.}

\item{INCX}{storage spacing between elements of \code{X}.}

\item{Y}{double precision vector or matrix that is updated in place.}

\item{INCY}{storage spacing between elements of \code{Y}.}
}
\value{
The modified object \code{Y} containing the element-wise sums.
}
\description{
Compute double precision DY := DX + DY for N elements, applying the
specified storage increments. This routine mirrors the BLAS DAXPY operation with
a unit scaling factor.
}
\details{
The implementation delegates to the BLAS \code{DAXPY} routine with a unit scaling
factor, making it equivalent to \code{daxpy(1.0, X, Y)} while exposing an interface
consistent with other low-level wrappers such as \code{dcopy} and \code{dscal}.
}
\examples{
set.seed(4669)
X <- matrix(runif(6), 3, 2)
Y <- matrix(runif(6), 3, 2)
dadd(X = X, Y = Y)
all.equal(Y, X + Y)

}
