% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df_grid_autoplot.R
\name{grid_autoplot}
\alias{grid_autoplot}
\title{Create a complete ggplot for spatial interaction models in a data frame}
\usage{
grid_autoplot(
  sim_df,
  key,
  flows = c("full", "destination", "attractiveness"),
  with_names = FALSE,
  with_positions = FALSE,
  show_destination = FALSE,
  show_attractiveness = FALSE,
  show_production = FALSE,
  cut_off = 100 * .Machine$double.eps^0.5,
  adjust_limits = FALSE,
  with_labels = FALSE,
  max_sims = 25,
  fw_params = NULL,
  ...
)
}
\arguments{
\item{sim_df}{a data frame of spatial interaction models, an object of class
\code{sim_df}}

\item{key}{the wrapping variable which acts as an identifier for spatial
interaction models}

\item{flows}{\code{"full"} (default),  \code{"destination"} or \code{"attractiveness"}, see
details.}

\item{with_names}{specifies whether the graphical representation includes
location names (\code{FALSE} by default)}

\item{with_positions}{specifies whether the graphical representation is based
on location positions (\code{FALSE} by default)}

\item{show_destination}{specifies whether the position based \code{"full"} flow
figure includes a representation of the destination flows (\code{FALSE} by
default)}

\item{show_attractiveness}{specifies whether the position based \code{"full"} flow
figure includes a representation of the attractivenesses  (\code{FALSE} by
default)}

\item{show_production}{specifies whether the position based \code{"full"} flow
figure includes a representation of the productions (\code{FALSE} by default)}

\item{cut_off}{cut off limit for inclusion of a graphical primitive when
\code{with_positions = TRUE}. In the full flow matrix representation, segments
are removed when their flow is smaller than the cut off. In the
attractiveness or destination representation, disks are removed when the
corresponding value is below the cut off.}

\item{adjust_limits}{if \code{FALSE} (default value), the limits of the position
based graph are not adjusted after removing graphical primitives. This
eases comparison between graphical representations with different cut off
value. If \code{TRUE}, limits are adjusted to the data using the standard
ggplot2 behaviour.}

\item{with_labels}{if \code{FALSE} (default value) names are displayed using plain
texts. If \code{TRUE}, names are shown using labels.}

\item{max_sims}{the maximum number of spatial interaction models allowed in
the \code{sim_df} data frame}

\item{fw_params}{parameters for the \link[ggplot2:facet_wrap]{ggplot2::facet_wrap} call (if non
\code{NULL})}

\item{...}{additional (named) parameters passed to \code{\link[=autoplot.sim]{autoplot.sim()}}}
}
\value{
a ggplot object
}
\description{
This function combines spatial interaction model representations similar to
the ones produced by \code{\link[=autoplot.sim]{autoplot.sim()}} into a single ggplot. It provides an
alternative graphical representation to the one produced by
\code{\link[=autoplot.sim_df]{autoplot.sim_df()}} for collection of spatial interaction models in a
\code{sim_df} object.
}
\details{
The rationale of \code{\link[=autoplot.sim_df]{autoplot.sim_df()}} is to display a single value for each
spatial interaction model (SIM) in the \code{sim_df} data frame. On the contrary,
this function produces a full graphical representation of each SIM. It is
therefore limited to small collection of SIMs (as specified by the \code{max_sims}
parameter which default to 25).

Under the hood, the function uses \code{\link[=fortify.sim]{fortify.sim()}} and shares code with
\code{\link[=autoplot.sim]{autoplot.sim()}} to have identical representations. It is simply based on
facet wrapping facility of ggplot2. In particular the \code{key} parameter is used
as the wrapping variable in the call to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. If not
specified, the function generates an \code{id} variable which ranges from 1 to the
number of SIMs in the \code{sim_df} data frame. If specified, it is evaluated in
the context of the data frame and used for wrapping. Notice that if the
expression evaluates to identical values for different SIMs, they will be
drawn on the same panel of the final figure, which may end up with
meaningless representations. Parameters of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} can be set
using the \code{fw_params} parameter (in a list).
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
positions <- as.matrix(french_cities[1:10, c("th_longitude", "th_latitude")])
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.35, by = 0.1),
  seq(1, 2.5, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
  destination_data = list(
    names = french_cities$name[1:10],
    positions = positions
  ),
  origin_data = list(
    names = french_cities$name[1:10],
    positions = positions
  )
)
all_flows_df <- sim_df(all_flows)
## default display: flows as matrices
grid_autoplot(all_flows_df)
## custom wrapping variable
grid_autoplot(all_flows_df, paste(alpha, "~", beta))
## bar plots
grid_autoplot(all_flows_df, flows = "attractiveness")
## with positions
grid_autoplot(all_flows_df, with_positions = TRUE, show_destination = TRUE) +
  ggplot2::scale_linewidth_continuous(range = c(0, 1)) +
  ggplot2::scale_size_continuous(range = c(0, 2)) +
  ggplot2::coord_sf(crs = "epsg:4326")
\dontshow{\}) # examplesIf}
}
