% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{grid_is_terminal}
\alias{grid_is_terminal}
\title{Extract all terminal status from a collection of spatial interaction models}
\usage{
grid_is_terminal(sim_list, definition = c("ND", "RW"), ...)
}
\arguments{
\item{sim_list}{a collection of non bipartite spatial interaction models, an
object of class \code{sim_list}}

\item{definition}{terminal definition, either \code{"ND"} (for Nystuen & Dacey,
default) or \code{"RW"} (for Rihll & Wilson), see details.}

\item{...}{additional parameters for the \code{\link[=is_terminal]{is_terminal()}} function}
}
\value{
a matrix of terminal status at the destination locations
}
\description{
The function extract terminal status from all the spatial interaction models
of the collection and returns them in a matrix in which each row corresponds
to a model and each column to a destination location. The value at row \code{i}
and column \code{j} is \code{TRUE} if destination \code{j} is a terminal in model \code{i}. This
function applies only to non bipartite models.
}
\details{
See \code{\link[=terminals]{terminals()}} for the definition of terminal locations.
}
\examples{
distances <- french_cities_distances[1:15, 1:15] / 1000 ## convert to km
production <- log(french_cities$population[1:15])
attractiveness <- log(french_cities$area[1:15])
all_flows <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1,
  bipartite = FALSE
)
g_df <- grid_is_terminal(all_flows)
## should be 12 rows (3 times 4 parameter pairs) and 15 columns (15
## destination locations)
dim(g_df)
}
\seealso{
\code{\link[=is_terminal]{is_terminal()}} and \code{\link[=grid_blvim]{grid_blvim()}}
}
