% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-submit.R
\name{input_submit_textarea}
\alias{input_submit_textarea}
\alias{update_submit_textarea}
\title{Create a textarea input control with explicit submission}
\usage{
input_submit_textarea(
  id,
  label = NULL,
  ...,
  placeholder = NULL,
  value = "",
  width = "min(680px, 100\%)",
  rows = 1,
  button = NULL,
  toolbar = NULL,
  submit_key = c("enter+modifier", "enter")
)

update_submit_textarea(
  id,
  ...,
  value = NULL,
  placeholder = NULL,
  label = NULL,
  submit = FALSE,
  focus = FALSE,
  session = get_current_session()
)
}
\arguments{
\item{id}{The input ID.}

\item{label}{The label to display above the input control. If \code{NULL}, no
label is displayed.}

\item{...}{Additional attributes to apply to the underlying \verb{<textarea>}
element (e.g., spellcheck, autocomplete, etc).}

\item{placeholder}{The placeholder text for the user input.}

\item{value}{The value to set the user input to.}

\item{width}{Any valid CSS unit (e.g., \code{width="100\%"}).}

\item{rows}{The number of rows (i.e., height) of the textarea. This essentially
sets the minimum height -- the textarea can grow taller as the user
enters more text.}

\item{button}{A \link[htmltools:builder]{htmltools::tags} element to use for the submit button. It's recommended
that this be a \code{\link[=input_task_button]{input_task_button()}} since it will automatically provide a
busy indicator (and disable) until the next flush occurs. Note also that if
the submit button launches a \link[shiny:ExtendedTask]{shiny::ExtendedTask}, this button can also be bound
to the task (\code{\link[=bind_task_button]{bind_task_button()}}) and/or manually updated for more
accurate progress reporting (\code{\link[=update_task_button]{update_task_button()}}).}

\item{toolbar}{A list of optional UI elements (e.g., links, icons) to
display next to the submit button.}

\item{submit_key}{A character string indicating what keyboard event should
trigger the submit button. The default is \code{enter+modifier}, which requires
the user to hold down Ctrl (or Cmd on Mac) before pressing Enter to
submit. This helps prevent accidental submissions. To allow submission with
just the Enter key, use \code{enter}. In this case, the user can still insert
new lines using Shift+Enter or Alt+Enter.}

\item{submit}{Whether to automatically submit the text for the user. Requires \code{value}.}

\item{focus}{Whether to move focus to the input element. Requires \code{value}.}

\item{session}{The \code{session} object; using the default is recommended.}
}
\value{
A textarea input control that can be added to a UI definition.
}
\description{
Creates a textarea input where users can enter multi-line text and submit
their input using a dedicated button or keyboard shortcut. This control is
ideal when you want to capture finalized input, rather than reacting to every
keystroke, making it useful for chat boxes, comments, or other scenarios
where users may compose and review their text before submitting.
}
\section{Server value}{

The server receives a character string containing the user's text input.

\strong{Important:} The initial server value is always \code{""} (empty string),
regardless of any \code{value} parameter provided to \code{input_submit_textarea()}.
The server value updates only when the user explicitly submits the input by
either pressing the Enter key (possibly with a modifier key) or clicking the
submit button.
}

\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(bslib)

ui <- page_fluid(
  input_submit_textarea("text", placeholder = "Enter some input..."),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({
    req(input$text)
    Sys.sleep(2)
    paste("You entered:", input$text)
  })
}
shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=update_submit_textarea]{update_submit_textarea()}}, \code{\link[=input_task_button]{input_task_button()}}
}
