% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_create_readme.R
\name{btw_task_create_readme}
\alias{btw_task_create_readme}
\title{Task: Create a Polished README}
\usage{
btw_task_create_readme(
  ...,
  client = NULL,
  mode = c("app", "console", "client", "tool")
)
}
\arguments{
\item{...}{Additional context to provide to the AI. This can be any text or
R objects that can be converted to text using \code{\link[=btw]{btw()}}.}

\item{client}{An \link[ellmer:Chat]{ellmer::Chat} client or a \code{provider/model} string to be
passed to \code{\link[ellmer:chat-any]{ellmer::chat()}} to create a chat client. Defaults to
\code{\link[ellmer:chat_anthropic]{ellmer::chat_anthropic()}}. You can use the \code{btw.client} option to set a
default client for new \code{btw_client()} calls, or use a \code{btw.md} project file
for default chat client settings, like provider and model. We check the
\code{client} argument, then the \code{btw.client} R option, and finally the \code{btw.md}
project file (falling back to user-level \code{btw.md} if needed), using only the
client definition from the first of these that is available.}

\item{mode}{The mode to run the task in, which affects what is returned from
this function. \code{"app"} and \code{"console"} modes launch interactive sessions,
while \code{"client"} and \code{"tool"} modes return objects for programmatic use.}
}
\value{
When \code{mode} is \code{"app"} or \code{"console"}, this function launches an
interactive session in the browser or the R console, respectively. The
ellmer chat object with the conversation history is returned invisibly
when the session ends.

When \code{mode} is \code{"client"}, this function returns the configured ellmer
chat client object. When \code{mode} is \code{"tool"}, this function returns an
ellmer tool object that can be used in other chat instances.
}
\description{
Create a compelling, user-focused README file for your project.
If launched in app or console mode, this task will start an interactive chat
session to guide you through the process of creating a polished README that
clearly communicates value and helps potential users make informed decisions.

This task focuses on creating READMEs for END USERS, not developers, with
emphasis on clarity, accessibility, and authentic communication of value.
The process involves exploring your project files, understanding your target
audience and goals, proposing a structure, and then iteratively drafting
each section with your input.
}
\examples{
withr::with_envvar(list(ANTHROPIC_API_KEY = "example"), {
  btw_task_create_readme(mode = "tool", client = "anthropic")
})

}
\seealso{
Other task and agent functions: 
\code{\link{btw_task_create_btw_md}()}
}
\concept{task and agent functions}
