% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{ancestors}
\alias{ancestors}
\title{Get ancestors of nodes in a \code{caugi}}
\usage{
ancestors(cg, nodes = NULL, index = NULL)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{nodes}{A vector of node names, a vector of unquoted
node names, or an expression combining these with \code{+} and \code{c()}.}

\item{index}{A vector of node indexes.}
}
\value{
Either a character vector of node names (if a single node is
requested) or a list of character vectors (if multiple nodes are requested).
}
\description{
Get ancestors of nodes in a \code{caugi}
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
ancestors(cg, "A") # NULL
ancestors(cg, index = 2) # "A"
ancestors(cg, "B") # "A"
ancestors(cg, c("B", "C"))
#> $B
#> [1] "A"
#>
#> $C
#> [1] "A" "B"

}
\seealso{
Other queries: 
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
