% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{condition_marginalize}
\alias{condition_marginalize}
\title{Marginalize and/or condition on variables in an ancestral graph (AG)}
\usage{
condition_marginalize(cg, cond_vars = NULL, marg_vars = NULL)
}
\arguments{
\item{cg}{A \code{caugi} ancestral graph of class \code{"AG"}.}

\item{cond_vars}{Character vector of nodes to condition on.}

\item{marg_vars}{Character vector of nodes to marginalize over.}
}
\value{
A \code{caugi} object of class \code{"AG"}.
}
\description{
Marginalize variables out of an AG, and/or condition on variables.
Depending on the structure, it could produce a graph with directed,
bidirected, and undirected edges.
}
\examples{
mg <- caugi(
  U \%-->\% X + Y,
  A \%-->\% X,
  B \%-->\% Y,
  class = "DAG"
)

condition_marginalize(mg, marg_vars = "U") # ADMG
condition_marginalize(mg, cond_vars = "U") # DAG

}
\references{
Definition 4.2.1 in Thomas Richardson. Peter Spirtes. "Ancestral graph
Markov models." Ann. Statist. 30 (4) 962 - 1030, August 2002.
\doi{10.1214/aos/1031689015}
}
\seealso{
Other operations: 
\code{\link{exogenize}()},
\code{\link{latent_project}()},
\code{\link{moralize}()},
\code{\link{mutate_caugi}()},
\code{\link{skeleton}()}
}
\concept{operations}
