% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_empty_caugi}
\alias{is_empty_caugi}
\title{Is the \code{caugi} graph empty?}
\usage{
is_empty_caugi(cg)
}
\arguments{
\item{cg}{A \code{caugi} object.}
}
\value{
A logical value indicating whether the graph is empty.
}
\description{
Checks if the given \code{caugi} graph is empty (has no nodes).
}
\examples{
cg_empty <- caugi(class = "DAG")
is_empty_caugi(cg_empty) # TRUE
cg_non_empty <- caugi(
  A \%-->\% B,
  class = "DAG"
)
is_empty_caugi(cg_non_empty) # FALSE

cg_no_edges_but_has_nodes <- caugi(
  A, B,
  class = "DAG"
)
is_empty_caugi(cg_no_edges_but_has_nodes) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
