% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\title{Create a caugi Graph Plot Object}
\arguments{
\item{x}{A \code{caugi} object. Must contain only directed edges for Sugiyama
layout.}

\item{layout}{Specifies the graph layout method. Can be:
\itemize{
\item A character string: \code{"auto"} (default), \code{"sugiyama"},
\code{"fruchterman-reingold"}, \code{"kamada-kawai"}, \code{"bipartite"}.
See \code{\link[=caugi_layout]{caugi_layout()}} for details.
\item A layout function: e.g., \code{caugi_layout_sugiyama},
\code{caugi_layout_bipartite}, etc. The function will be called with \code{x} and
any additional arguments passed via \code{...}.
\item A pre-computed layout data.frame with columns \code{name}, \code{x}, and \code{y}.
}}

\item{...}{Additional arguments passed to \code{\link[=caugi_layout]{caugi_layout()}}. For bipartite
layouts, include \code{partition} (logical vector) and \code{orientation} (\code{"rows"}
or \code{"columns"}).}

\item{node_style}{List of node styling parameters. Supports:
\itemize{
\item Appearance (passed to \code{gpar()}): \code{fill}, \code{col}, \code{lwd}, \code{lty}, \code{alpha}
\item Geometry: \code{padding} (text padding inside nodes in mm, default 2),
\code{size} (node size multiplier, default 1)
\item Local overrides via \code{by_node}: a named list of nodes with their
own style lists, e.g.
\code{by_node = list(A = list(fill = "red"), B = list(col = "blue"))}
}}

\item{edge_style}{List of edge styling parameters. Can specify global options
or per-type options via \code{directed}, \code{undirected}, \code{bidirected}, \code{partial}.
Supports:
\itemize{
\item Appearance (passed to \code{gpar()}): \code{col}, \code{lwd}, \code{lty}, \code{alpha}, \code{fill}.
\item Geometry: \code{arrow_size} (arrow length in mm, default 3), \code{circle_size}
(radius of endpoint circles for partial edges in mm, default 1.5)
\item Local overrides via \code{by_edge}: a named list with:
\itemize{
\item Node-wide styles: applied to all edges touching a node, e.g.
\code{A = list(col = "red", lwd = 2)}
\item Specific edges: nested named lists for particular edges, e.g.
\code{A = list(B = list(col = "blue", lwd = 4))}
}

Multiple levels can be combined: \strong{Style precedence} (highest to lowest):
specific edge settings > node-wide settings > edge type settings > global
settings.
}}

\item{label_style}{List of label styling parameters. Supports:
\itemize{
\item Appearance (passed to \code{gpar()}): \code{col}, \code{fontsize}, \code{fontface},
\code{fontfamily}, \code{cex}
}}

\item{tier_style}{List of tier box styling parameters. Tier boxes are shown
when \code{boxes = TRUE} is set within this list. Supports:
\itemize{
\item Appearance (passed to \code{gpar()}): \code{fill}, \code{col} (border color), \code{lwd},
\code{lty}, \code{alpha}
\item Geometry: \code{padding} (padding around tier nodes as proportion of plot range,
default 0.05)
\item Labels: \code{labels} (logical or character vector). If \code{TRUE}, uses tier names
from \code{tiers} argument. If a character vector, uses custom labels (one per
tier). If \code{FALSE} or \code{NULL} (default), no labels are shown.
\item Label styling: \code{label_style} (list with \code{col}, \code{fontsize}, \code{fontface}, etc.)
\item Values can be scalars (applied to all tiers) or vectors (auto-expanded to
each tier in order)
\item Local overrides via \code{by_tier}: a named list (using tier names from \code{tiers}
argument) or indexed list for per-tier customization, e.g.
\code{by_tier = list(exposures = list(fill = "lightblue"), outcome = list(fill = "yellow"))}
or \verb{by_tier = list(}1\verb{ = list(fill = "lightblue"))}
}}

\item{main}{Optional character string for plot title. If \code{NULL} (default),
no title is displayed.}

\item{title_style}{List of title styling parameters. Supports:
\itemize{
\item Appearance (passed to \code{gpar()}): \code{col}, \code{fontsize}, \code{fontface},
\code{fontfamily}, \code{cex}
}}

\item{outer_margin}{Grid unit specifying outer margin around the plot.
Default is \code{grid::unit(2, "mm")}.}

\item{title_gap}{Grid unit specifying gap between title and graph.
Default is \code{grid::unit(1, "lines")}.}
}
\value{
A \code{caugi_plot} object that wraps a \code{gTree} for grid graphics
display. The plot is automatically drawn when printed or explicitly
plotted.
}
\description{
Creates a grid graphics object (gTree) representing a \code{caugi} graph.
If the graph has not been built yet, it will be built automatically before
plotting. This implementation uses idiomatic grid graphics with viewports
for proper coordinate handling.
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

plot(cg)

# Use a specific layout method (as string)
plot(cg, layout = "kamada-kawai")

# Use a layout function
plot(cg, layout = caugi_layout_sugiyama)

# Pre-compute layout and use it
coords <- caugi_layout_fruchterman_reingold(cg)
plot(cg, layout = coords)

# Bipartite layout with a function
cg_bp <- caugi(A \%-->\% X, B \%-->\% X, C \%-->\% Y)
partition <- c(TRUE, TRUE, TRUE, FALSE, FALSE)
plot(cg_bp, layout = caugi_layout_bipartite, partition = partition)

# Customize nodes
plot(cg, node_style = list(fill = "lightgreen", padding = 0.8))

# Customize edges by type
plot(
  cg,
  edge_style = list(
    directed = list(col = "blue", arrow_size = 4),
    undirected = list(col = "red")
  )
)

# Add a title
plot(cg, main = "Causal Graph")

# Customize title
plot(
  cg,
  main = "My Graph",
  title_style = list(fontsize = 18, col = "blue", fontface = "italic")
)

}
\seealso{
Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}}
}
\concept{plotting}
