% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-dot.R
\name{to_dot}
\alias{to_dot}
\title{Export caugi Graph to DOT Format}
\usage{
to_dot(x, graph_attrs = list(), node_attrs = list(), edge_attrs = list())
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{graph_attrs}{Named list of graph attributes (e.g.,
\code{list(rankdir = "LR")}).}

\item{node_attrs}{Named list of default node attributes.}

\item{edge_attrs}{Named list of default edge attributes.}
}
\value{
A \code{caugi_dot} object containing the DOT representation.
}
\description{
Converts a caugi graph to the Graphviz DOT format as a string.
The DOT format can be used with Graphviz tools for visualization
and analysis.
}
\details{
The function handles different edge types:
\itemize{
\item Directed edges (\verb{-->}) use \verb{->} in DOT
\item Undirected edges (\verb{---}) use \verb{--} in DOT (or \verb{->} with \code{dir=none} in digraphs)
\item Bidirected edges (\verb{<->}) use \verb{->} with \verb{[dir=both]} attribute
\item Partial edges (\verb{o->}) use \verb{->} with \verb{[arrowtail=odot, dir=both]} attribute
}
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

# Get DOT string
dot <- to_dot(cg)
dot@content

# With custom attributes
dot <- to_dot(
  cg,
  graph_attrs = list(rankdir = "LR"),
  node_attrs = list(shape = "box")
)

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
