% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-dot.R
\name{write_dot}
\alias{write_dot}
\title{Write caugi Graph to DOT File}
\usage{
write_dot(x, file, ...)
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{file}{Path to output file.}

\item{...}{Additional arguments passed to \code{\link[=to_dot]{to_dot()}}, such as \code{graph_attrs},
\code{node_attrs}, and \code{edge_attrs}.}
}
\value{
Invisibly returns the path to the file.
}
\description{
Writes a caugi graph to a file in Graphviz DOT format.
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

\dontrun{
# Write to file
write_dot(cg, "graph.dot")

# With custom attributes
write_dot(
  cg,
  "graph.dot",
  graph_attrs = list(rankdir = "LR")
)
}

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
