# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/person/fr_CH/__init__.py

person_formats_female_fr_ch <- c(
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names1}}-{{last_names2}}"
)

person_formats_male_fr_ch <- c(
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names1}}-{{last_names2}}"
)

person_formats_fr_ch <- c(person_formats_male_fr_ch, person_formats_female_fr_ch)

# source: http://www.bfs.admin.ch/bfs/portal/fr/index/news/publikationen.html?publicationID=6704
person_first_names_male_fr_ch <- c(
  "Alain",
  "Albert",
  "Alexandre",
  "Andr\u00e9",
  "Antonio",
  "Arthur",
  "Bernard",
  "Bruno",
  "Charles",
  "Christian",
  "Christophe",
  "Claude",
  "Daniel",
  "David",
  "Eric",
  "Ethan",
  "Florian",
  "Fran\u00e7ois",
  "Fr\u00e9d\u00e9ric",
  "Gabriel",
  "Georges",
  "Gilbert",
  "Guillaume",
  "G\u00e9rard",
  "Henri",
  "Hugo",
  "Jacques",
  "Jean",
  "Jean-Claude",
  "Jean-Pierre",
  "Jonathan",
  "Jos\u00e9",
  "Julien",
  "Kevin",
  "Laurent",
  "Louis",
  "Lo\u00efc",
  "Luca",
  "Lucas",
  "L\u00e9o",
  "Manuel",
  "Marcel",
  "Mathieu",
  "Matteo",
  "Maurice",
  "Maxime",
  "Michael",
  "Michel",
  "Nathan",
  "Nicolas",
  "Noah",
  "Nolan",
  "Olivier",
  "Pascal",
  "Patrick",
  "Paul",
  "Philippe",
  "Pierre",
  "Raymond",
  "Ren\u00e9",
  "Robert",
  "Roger",
  "Roland",
  "Romain",
  "Samuel",
  "St\u00e9phane",
  "S\u00e9bastien",
  "Thierry",
  "Thomas",
  "Th\u00e9o",
  "Vincent"
)

person_first_names_female_fr_ch <- c(
  "Alice",
  "Alicia",
  "Ana",
  "Anna",
  "Anne",
  "Aur\u00e9lie",
  "Camille",
  "Caroline",
  "Catherine",
  "Chantal",
  "Charlotte",
  "Chlo\u00e9",
  "Christiane",
  "Christine",
  "Clara",
  "Claudine",
  "Corinne",
  "C\u00e9line",
  "Danielle",
  "Denise",
  "Eliane",
  "Elisa",
  "Elisabeth",
  "Elodie",
  "Emilie",
  "Emma",
  "Eva",
  "Fabienne",
  "Fran\u00e7oise",
  "Georgette",
  "Germaine",
  "H\u00e9l\u00e8ne",
  "Isabelle",
  "Jacqueline",
  "Jeanne",
  "Jessica",
  "Josiane",
  "Julie",
  "Laetitia",
  "Lara",
  "Laura",
  "Laurence",
  "Liliane",
  "Lisa",
  "Lucie",
  "L\u00e9a",
  "Madeleine",
  "Manon",
  "Marcelle",
  "Marguerite",
  "Maria",
  "Marianne",
  "Marie",
  "Mathilde",
  "Monique",
  "M\u00e9lanie",
  "Nathalie",
  "Nelly",
  "Nicole",
  "Odette",
  "Patricia",
  "Sandra",
  "Sandrine",
  "Sara",
  "Sarah",
  "Simone",
  "Sophie",
  "St\u00e9phanie",
  "Suzanne",
  "Sylvie",
  "Th\u00e9r\u00e8se",
  "Val\u00e9rie",
  "Vanessa",
  "V\u00e9ronique",
  "Yvette",
  "Yvonne",
  "Zo\u00e9"
)

person_first_names_fr_ch <- c(person_first_names_male_fr_ch, person_first_names_female_fr_ch)

# source = http://kunden.eye.ch/swissgen/rsr/index.html
person_last_names_fr_ch <- c(
  "Aebi",
  "Aeby",
  "Alber",
  "Babey",
  "Badan",
  "Badel",
  "Bahon",
  "Balmat",
  "Barbey",
  "Barillon",
  "Barman",
  "Bavaud",
  "Beguin",
  "Berberat",
  "Bernasconi",
  "Besan\u00e7on",
  "Besen\u00e7on",
  "Besse",
  "Beuchat",
  "Beuret",
  "Beurret",
  "Blanc",
  "Bochud",
  "Boechat",
  "Boichat",
  "Boillat",
  "Bonvin",
  "Bonvini",
  "Botteron",
  "Bourquard",
  "Bourquin",
  "Bouvier",
  "Bovet",
  "Brahier",
  "Brandt",
  "Broquet",
  "Bugnon",
  "Bujard",
  "B\u00e9guelin",
  "Candaux",
  "Carraud",
  "Carraux",
  "Carron",
  "Cattin",
  "Chappuis",
  "Chapuis",
  "Charpi\u00e9",
  "Chatriand",
  "Chatriant",
  "Chaudet",
  "Chenaux",
  "Chevalley",
  "Chevrolet",
  "Chopard",
  "Coigny",
  "Comman",
  "Comment",
  "Comte",
  "Conrad",
  "Corbat",
  "Corboz",
  "Cornut",
  "Cornuz",
  "Corpataux",
  "Cosandey",
  "Cosendey",
  "Cossy",
  "Courvoisier",
  "Cousin",
  "Cretton",
  "Crevoisier",
  "Crivelli",
  "Curdy",
  "de Dardel",
  "Delado\u00eby",
  "Del\u00e8ze",
  "Deshusses",
  "Diesbach",
  "Droz",
  "Dubey",
  "Duroux",
  "Duvanel",
  "D\u00e9l\u00e8ze",
  "Ev\u00e9quoz",
  "Fonjallaz",
  "Francillon",
  "Galland",
  "Georges",
  "Gilli\u00e8ron",
  "Gilli\u00e9ron",
  "Godet",
  "Grand",
  "Grojean",
  "Grosjean",
  "Gub\u00e9ran",
  "Humbert",
  "Isella",
  "Jacot-Descombes",
  "Jacot-Guillarmod",
  "Joly",
  "Jomini",
  "Joye",
  "Julliard",
  "Maire",
  "Marti",
  "Martin",
  "Marty",
  "Masseron",
  "Matile",
  "Mayor",
  "Menthonnex",
  "Mercier",
  "Meyer",
  "Monnard",
  "Monnet",
  "Monnet",
  "Monney",
  "Montandon",
  "Morand",
  "Morard",
  "Mottet",
  "Mottiez",
  "Muriset",
  "Musy",
  "M\u00fcller",
  "Niquille",
  "Nussl\u00e9",
  "N\u00fcsslin",
  "Paccot",
  "Pachoud",
  "Paschoud",
  "Pasquier",
  "Peitrequin",
  "Pellet",
  "Piccand",
  "Polla",
  "Privet",
  "Quartier",
  "Rapin",
  "Rappaz",
  "Rapraz",
  "Rey",
  "Robadey",
  "Robert",
  "Romanens",
  "Rosselat",
  "Rosselet",
  "Rossellat",
  "Sandoz",
  "Sansonnens",
  "Saudan",
  "Thorens",
  "Th\u00e9raulaz",
  "Tinguely",
  "Treboux",
  "Uldry",
  "Vall\u00e9lian",
  "Vermeil",
  "Vienne",
  "Vonlanthen",
  "Vuille",
  "Wicht"
)

person_fr_ch <- list(
  first_names = person_first_names_fr_ch,
  first_names_male = person_first_names_male_fr_ch,
  first_names_female = person_first_names_female_fr_ch,
  last_names = person_last_names_fr_ch
)

#' @title Person Provider for French (Switzerland)
#' @inherit PersonProvider description details return
#' @export
#' @family fr
#' @family CH
#' @details Note for female and male components that we fall back on generic
#' versions if the locale
#' doesn't provide a male/female version.
#' e.g., if no female first name we use first
#' name
#' @examples
#' x <- PersonProvider_fr_CH$new()
#' x$locale
#' x$render()
#' x$first_name()
#' x$first_name_female()
#' x$first_name_male()
#' x$last_name()
#' x$last_name_female()
#' x$last_name_male()
PersonProvider_fr_CH <- R6::R6Class(
  "PersonProvider_fr_CH",
  inherit = PersonProvider,
  private = list(
    formats = person_formats_fr_ch,
    persons = person_fr_ch,
    locale_ = "fr_CH"
  )
)
