% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address-provider.R
\name{AddressProvider}
\alias{AddressProvider}
\title{AddressProvider}
\value{
Returns an AddressProvider object.
}
\description{
Object to create addresses for a locale.
Makes use of \link{PersonProvider} for creating street names.
}
\details{
When there is no PersonProvider for this locale, we default back to en_US.
}
\note{
You cannot instantiate the Parent providers. You must use one of
the localized one.
}
\seealso{
Other ParentProviders: 
\code{\link{ColorProvider}},
\code{\link{CompanyProvider}},
\code{\link{InternetProvider}},
\code{\link{JobProvider}},
\code{\link{LoremProvider}},
\code{\link{PersonProvider}},
\code{\link{PhoneNumberProvider}},
\code{\link{TaxonomyProvider}},
\code{\link{UserAgentProvider}}
}
\concept{ParentProviders}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{AddressProvider}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AddressProvider-new}{\code{AddressProvider$new()}}
\item \href{#method-AddressProvider-address}{\code{AddressProvider$address()}}
\item \href{#method-AddressProvider-city}{\code{AddressProvider$city()}}
\item \href{#method-AddressProvider-street_name}{\code{AddressProvider$street_name()}}
\item \href{#method-AddressProvider-street_address}{\code{AddressProvider$street_address()}}
\item \href{#method-AddressProvider-postcode}{\code{AddressProvider$postcode()}}
\item \href{#method-AddressProvider-init_person_provider}{\code{AddressProvider$init_person_provider()}}
\item \href{#method-AddressProvider-clone}{\code{AddressProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{AddressProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{AddressProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-address}{}}}
\subsection{Method \code{address()}}{
Create an address, a combination of street, postal code and city.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-city"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-city}{}}}
\subsection{Method \code{city()}}{
Create a city
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$city()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-street_name"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-street_name}{}}}
\subsection{Method \code{street_name()}}{
Create a street name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$street_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-street_address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-street_address}{}}}
\subsection{Method \code{street_address()}}{
Create a street address, a combination of streetname and house indicator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$street_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-postcode"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-postcode}{}}}
\subsection{Method \code{postcode()}}{
Create a postal code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$postcode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-init_person_provider"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-init_person_provider}{}}}
\subsection{Method \code{init_person_provider()}}{
initialize the person provider (for use in addresses based on names)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$init_person_provider(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{locale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
