% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat4R_history.R
\name{chat4R_history}
\alias{chat4R_history}
\title{chat4R_history: Use chat history for interacting with GPT.}
\usage{
chat4R_history(
  history,
  api_key = Sys.getenv("OPENAI_API_KEY"),
  Model = "gpt-4o-mini",
  temperature = 1
)
}
\arguments{
\item{history}{A list of message objects.
Each object should have a 'role' that can be 'system', 'user', or 'assistant',
and 'content' which is the content of the message from that role.}

\item{api_key}{A string. Input your OpenAI API key. Defaults to the value of the environment variable "OPENAI_API_KEY".}

\item{Model}{A string. The model to use for the chat completion. Default is "gpt-4o-mini".}

\item{temperature}{The temperature to use for the chat completion. Default is 1.}
}
\value{
A data frame containing the parsed response from the Web API server.
}
\description{
This function use the chat history with the the specified GPT model, and chat the AI model.
}
\details{
Chat History for R
}
\examples{
\dontrun{
Sys.setenv(OPENAI_API_KEY = "Your API key")

history <- list(list('role' = 'system', 'content' = 'You are a helpful assistant.'),
                list('role' = 'user', 'content' = 'Who won the world series in 2020?'))

chat4R_history(history)
}

}
\author{
Satoshi Kume
}
