% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_rebuild.R
\name{cpp_rebuild}
\alias{cpp_rebuild}
\title{Low-level attribute re-constructor}
\usage{
cpp_rebuild(target, source, target_attr_names, source_attr_names, shallow_copy)
}
\arguments{
\item{target}{Target object you wish to rebuild attributes on.}

\item{source}{Source object to copy attributes from.}

\item{target_attr_names}{\verb{[character(n)]} Names of target attributes to keep.}

\item{source_attr_names}{\verb{[character(n)]} Names of source attributes
to copy onto target.}

\item{shallow_copy}{\verb{[logical(1)]} Should target be shallow copied before re-building?
If \code{FALSE} attributes are added in-place.}
}
\value{
An object similar to \code{source}.
}
\description{
Low-level attribute re-constructor
}
\details{
\code{cpp_rebuild()} is mostly a convenience function to help with choosing
exactly which attributes to copy onto the target object.
\code{rebuild()} is a related generic function with rebuild methods for
common objects (currently only \code{tbl_df}, \code{data.frame} and \code{data.table}).
For examples of further rebuild methods, see the fastplyr package.

To modify attributes yourself you can of course use base R attribute functions
like \code{attr()} and \code{attributes()} or cheapr's more convenient \code{attrs_modify}.
}
\seealso{
\link{rebuild} \link{attrs_modify}
}
