% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_common_risk.R
\name{ci_prop_diff_mh_strata}
\alias{ci_prop_diff_mh_strata}
\title{Mantel-Haenszel Common Risk Difference Confidence Interval}
\usage{
ci_prop_diff_mh_strata(
  x,
  by,
  strata,
  conf.level = 0.95,
  sato_var = TRUE,
  data = NULL
)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{strata}{(\code{numeric}) \cr A vector specifying the stratum for each observation. It needs
to be the length of x or a multiple of x if multiple levels of strata are
present. Can also be a column name (or vector of column names NOT quoted)
if a data frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{sato_var}{(\code{logical})\cr Use Sato variance estimate}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{estimate}{The Mantel-Haenszel estimated common risk difference}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{variance}{Variance estimate}
\item{statistic}{Z-Statistic under the null hypothesis, assuming a common risk difference of 0}
\item{p.value}{p-value under the null hypothesis, assuming a common risk difference of 0}
\item{method}{Description of the method used ("Mantel-Haenszel Confidence Interval, Sato Variance")
or ("Mantel-Haenszel Confidence Interval, Independent Binomial") }
}
\description{
Calculates the confidence interval for the Mantel-Haenszel estimate of the
common risk difference across multiple 2x2 tables (strata), using the Sato
or Independent Binomial variance estimator.
}
\details{
The Mantel-Haenszel common risk difference is computed as:

\deqn{\hat{\delta}_{MH} = \frac{\sum_{k} w_k \hat{\delta}_k }{\sum_{k} w_k}}

where \eqn{w_k = \frac{n_{xk} n_{yk}}{N_k}},
\eqn{\hat{\delta}_k = s_{xk}/n_{xk} - y_{yk}/n_{yk}},
\eqn{N_k = n_{xk} + n_{yk}},
\eqn{s_{xk}} and \eqn{s_{yk}} are the number of events in each group, and \eqn{n_{xk}},
and \eqn{n_{yk}} are the group sizes in stratum \eqn{k}.

The Sato variance is:

\deqn{\hat{\sigma}^2(\hat{\delta}_{MH}) = \frac{\hat{d}_{MH} \sum_{k}{P_k} + \sum_k Q_k}{\left( \sum_k w_k \right)^2}}

where \eqn{P_k = \frac{n_{xk}^2 s_{yk} - n_{yk}^2 s_{xk} + n_{xk} n_{yk} (n_{yk} - n_{xk})/2}{N_k^2}}
and \eqn{Q_k = \frac{s_{xk}(n_{yk} - s_{yk}) + s_{yk}(n_{xk} - s_{xk})}{2 N_k}}.

The Cochran Independent Binomial variance is:

\deqn{\hat{\sigma}^2(\hat{\delta}_{C}) = \sum_{k} w_k^2 \left[
\frac{\hat{p}_{1k}(1 - \hat{p}_{1k})}{n_{1k}} +
\frac{\hat{p}_{2k}(1 - \hat{p}_{2k})}{n_{2k}}
\right]}

where \eqn{\hat{p}_{1k} = \frac{s_{xk}}{n_{xk}}}
and \eqn{\hat{p}_{2k} = \frac{s_{yk}}{n_{yk}}}.

The confidence interval is then \eqn{\hat{\delta}_{MH} \pm z_{1-\alpha/2} \sqrt{\hat{\sigma}^2(\hat{d}_{MH})}}.
}
\examples{
# Generate binary samples with strata
responses <- expand(c(9, 3, 7, 2), c(10, 10, 10, 10))
arm <- rep(c("treat", "control"), 20)
strata <- rep(c("stratum1", "stratum2"), times = c(20, 20))

# Calculate common risk difference
ci_prop_diff_mh_strata(x = responses, by = arm, strata = strata)
# Calculate risk difference with independent binomial variance
ci_prop_diff_mh_strata(x = responses, by = arm, strata = strata, sato_var = FALSE)
}
\references{
Agresti, A. (2013). Categorical Data Analysis. 3rd Edition. John Wiley & Sons, Hoboken, NJ p. 231
Cochran, W.G. (1954). The Combination of estimates from different experiments. Biometrics, 10(1), p.101-129
}
