% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_color_table.R
\name{create_color_table}
\alias{create_color_table}
\title{Create Color Swatch Table}
\usage{
create_color_table(df)
}
\arguments{
\item{df}{A data frame with at minimum a column named \code{hex} containing
hexadecimal color codes. Optionally can include a \code{name} column for
color names. If \code{name} is not present, only hex codes and swatches
will be displayed.}
}
\value{
A \code{gt} table object displaying the colors with visual swatches.
The table will have columns for color names (if provided), hex codes, and
a color swatch column where each cell is filled with the corresponding color.
}
\description{
Creates a visual table displaying color names, hex codes, and color swatches.
Requires the \code{gt} package to be installed.
}
\details{
This function creates an enhanced table using the \code{gt} package. The table
includes:
\itemize{
\item Color names (if the \code{name} column exists in the input)
\item Hexadecimal color codes
\item Visual color swatches (cells filled with the actual colors)
}

The \code{gt} package must be installed to use this function. If it's not
installed, the function will provide instructions on how to install it.

You can pass the output of \code{\link{get_color_data}} directly to this
function, or create a custom data frame with your own color selection.
}
\examples{
# Create a table with a few colors
colors_df <- data.frame(
  name = c("red", "blue", "forestgreen"),
  hex = c("#FF0000", "#0000FF", "#228B22")
)

# Only run if gt is available
if (requireNamespace("gt", quietly = TRUE)) {
  create_color_table(colors_df)

  # Use with get_color_data() - show first 10 colors
  all_colors <- get_color_data()
  create_color_table(head(all_colors, 10))

  # Create a table with only specific colors
  blue_colors <- all_colors[grepl("blue", all_colors$name), ]
  create_color_table(head(blue_colors, 20))

  # Minimal example with just hex codes
  hex_only <- data.frame(hex = c("#FF0000", "#00FF00", "#0000FF"))
  create_color_table(hex_only)
}
}
\seealso{
\code{\link{get_color_data}} for obtaining the complete color database,
\code{\link{color_to_hex}} for converting color names to hex codes
}
