#' Simulated trial data
#'
#' Simulated trial data list `datlist` that is generated by `singleTrial.R` and contains
#' all the necessary information to perform confidence analysis.
#'
#' @docType data
#'
#' @usage data(datlist)
#'
#' @format An object of class \code{"list"}
#' \describe{
#'  \item{subjid}{Subject ID from 1 to maximum sample size}
#'  \item{arm}{Treatment arm allocation for each subject}
#'  \item{dat}{Response for each subject (0 or 1)}
#'  \item{arrival.day}{Arrival time (days) for each subject throughout trial duration}
#'  \item{obstime}{Obveration time (days) for each subject; when response is observed}
#' }
#' @references This data set was created for the confidenceSim package.
#' @keywords datasets
#' @examples
#'
#' data(datlist)
#' head(datlist)
#'
"datlist"
