% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_example.R
\docType{data}
\name{cor_example}
\alias{cor_example}
\title{Example Correlation Matrix with Block Structure}
\format{
A 20x20 numeric correlation matrix with row and column names
V1-V20. The matrix has four distinct correlation blocks:
\describe{
\item{Block 1 (V1-V5)}{High correlation: mean = 0.81,
range = (0.75, 0.95)}
\item{Block 2 (V6-V10)}{Moderate correlation: mean = 0.57,
range = (0.5, 0.7)}
\item{Block 3 (V11-V15)}{Low correlation: mean = 0.28,
range = (0.2, 0.4)}
\item{Block 4 (V16-V20)}{Minimal correlation: mean = 0.06,
range = (0.0, 0.15)}
}
Between-block correlations are low (range = (0.0, 0.3)). The matrix
is guaranteed to be positive definite.
}
\source{
Generated with \code{data-raw/create_cor_example.R} using
seed 20250125.
}
\usage{
cor_example
}
\description{
A 20x20 correlation matrix with known block structure designed for
demonstrating threshold selection, algorithm comparison, and visualization
examples in vignettes.
}
\details{
This dataset provides a controlled correlation structure useful for:
\itemize{
\item Threshold sensitivity analysis (comparing results at
tau = 0.5, 0.7, 0.9)
\item Algorithm comparison (exact vs greedy modes)
\item Visualization examples (heatmaps, correlation distributions)
\item Reproducible benchmarks across vignettes
}

Expected behavior with different thresholds:
\itemize{
\item tau = 0.5: Block 1 requires pruning (all pairs > 0.75)
\item tau = 0.7: Blocks 1-2 require pruning
\item tau = 0.9: Only Block 1 requires pruning
}
}
\examples{
data(cor_example)

# Matrix dimensions
dim(cor_example)

# Visualize structure
if (requireNamespace("corrplot", quietly = TRUE)) {
  corrplot::corrplot(cor_example, method = "color", type = "upper",
                     tl.col = "black", tl.cex = 0.7)
}

# Distribution of correlations
hist(cor_example[upper.tri(cor_example)],
     breaks = 30,
     main = "Distribution of Correlations in cor_example",
     xlab = "Correlation",
     col = "steelblue")

# Use with MatSelect
library(corrselect)
results <- MatSelect(cor_example, threshold = 0.7, method = "els")
show(results)

}
\keyword{datasets}
