% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{as_yaml}
\alias{as_yaml}
\title{Serialize a validated configuration list to YAML}
\usage{
as_yaml(config, path)

as_yaml(config, path)
}
\arguments{
\item{config}{List specification following the package grammar.}

\item{path}{Output file path (for example \code{"case.yml"}).}
}
\value{
The input \code{path}, returned invisibly, to allow use in pipelines.

The input \code{path}, invisibly.
}
\description{
Validates a configuration list against the package grammar using
\code{cfg_validate()} and serializes it to a YAML file on disk.
This helper is intended for reproducibility and interoperability,
allowing a fully specified in-memory configuration to be persisted
and reused in subsequent runs or edited manually by users.

Validates \code{config} and writes it to \code{path} as \code{'YAML'}.
}
\details{
The function performs validation before writing to disk. If validation
fails, an error is raised and no file is written. The YAML output is a
direct serialization of the validated configuration list and therefore
preserves all fields, including nested structures.
}
\examples{
tmp <- tempfile(fileext = ".yml")
cfg <- dcf_spec_template()
cfg$entry_yield <- 0.06
as_yaml(cfg, tmp)
stopifnot(file.exists(tmp))

cfg <- dcf_spec_template()
cfg$entry_yield <- 0.06
tmp <- tempfile(fileext = ".yml")
as_yaml(cfg, tmp)
stopifnot(file.exists(tmp))
unlink(tmp)

}
