% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratios.r
\name{compare_financing_scenarios}
\alias{compare_financing_scenarios}
\title{Compare three financing structures on a common  Discounted Cash Flow (DCF) base}
\usage{
compare_financing_scenarios(
  dcf_res,
  acq_price,
  ltv,
  rate,
  maturity,
  covenants = list(dscr_min = 1.25, ltv_max = 0.65)
)
}
\arguments{
\item{dcf_res}{List; result of \code{dcf_calculate()} for the unlevered
project. It is assumed to contain the cash-flow table and the input
exit yield in \code{dcf_res$inputs$exit_yield}.}

\item{acq_price}{Numeric scalar; acquisition base consistent with the
pricing convention used in \code{dcf_res} (for example HT, DI or value).}

\item{ltv}{Numeric scalar in \code{[0, 1)}; target loan-to-value ratio
at origination.}

\item{rate}{Numeric scalar in \code{[0, 1]}; annual interest rate used
to build the debt schedules.}

\item{maturity}{Integer scalar greater than or equal to 1; debt maturity
in years.}

\item{covenants}{Optional list of covenant thresholds, for example
\code{list(dscr_min = 1.25, ltv_max = 0.65)}. These values are passed
to \code{add_credit_ratios()} when computing credit ratios.}
}
\value{
A list with two components:
\item{summary}{A tibble that summarizes, for the all-equity, bullet and
amortizing cases, the main valuation metrics (IRR, NPV) and selected
credit indicators (for example minimum DSCR and maximum forward LTV).}
\item{details}{A named list with one element per scenario. Each element
contains the debt schedule (\code{schedule}), the full joined project
and debt cash-flow table (\code{full}), the credit-ratio table
(\code{ratios}), and the leveraged metrics object (\code{metrics}).}
}
\description{
Build and compare three financing setups for a given unlevered DCF:
\itemize{
\item an all-equity case,
\item a bullet debt structure,
\item an amortizing debt structure.
}
All three scenarios share the same acquisition base, interest rate,
maturity and target LTV. The function returns a summary table of key
investment and credit metrics, together with detailed objects for each
scenario.
}
