% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{equity_multiple_safe}
\alias{equity_multiple_safe}
\title{Safely compute the equity multiple for an equity cash-flow series}
\usage{
equity_multiple_safe(cf_equity)
}
\arguments{
\item{cf_equity}{Numeric vector of equity cash-flows over time.}
}
\value{
A single numeric scalar giving the equity multiple.
}
\description{
This helper computes the equity multiple as total distributions divided by
total contributions in absolute value.
}
\examples{
equity_multiple_safe(c(-100, 10, 10, 110))
equity_multiple_safe(c(-100, 30, 70))

\donttest{
err <- try(equity_multiple_safe(c(-100, -20)), silent = TRUE)
stopifnot(inherits(err, "try-error"))
}
}
\keyword{internal}
