% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratios.r
\name{forward_value_from_noi}
\alias{forward_value_from_noi}
\title{Forward value from next-period NOI}
\usage{
forward_value_from_noi(noi_vec, exit_yield, g_forward = NA_real_)
}
\arguments{
\item{noi_vec}{Numeric vector of annual NOI values.}

\item{exit_yield}{Numeric scalar; exit yield in decimal form (for example
0.05).}

\item{g_forward}{Optional numeric scalar giving a constant forward growth
rate. When supplied, the last element of \code{NOI_next} is constructed
as the last NOI multiplied by \code{1 + g_forward}. When \code{g_forward}
is \code{NA} (the default), a capped log-growth extrapolation is used
instead.}
}
\value{
A numeric vector of forward values with the same length as
\code{noi_vec}.
}
\description{
Compute a forward-value vector based on next-period NOI and an exit yield.
Given a series of annual NOI values, the function constructs a vector
NOI can be obtained either from a fixed forward growth rate or from a
simple extrapolation of observed growth.
}
