% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{price_from_cap}
\alias{price_from_cap}
\title{Acquisition price from an entry capitalization rate}
\usage{
price_from_cap(noi_y1, entry_yield, acq_cost_rate = 0)
}
\arguments{
\item{noi_y1}{numeric(1). Expected \eqn{NOI} for year 1.}

\item{entry_yield}{numeric(1) in \code{(0,1]}. Entry capitalization rate.}

\item{acq_cost_rate}{numeric(1) in \code{[0,1)}. Acquisition cost rate.}
}
\value{
list(ht = net price, di = all-in price).
}
\description{
Converts a given \code{NOI_y1} and \code{entry_yield} into a net
purchase price (HT) and an all-in price including acquisition costs
(via \code{acq_cost_rate}).
}
\examples{
price_from_cap(500000, 0.05, acq_cost_rate = 0.07)
}
