% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_equity_cashflows}
\alias{styles_equity_cashflows}
\title{Extract leveraged equity cash flows by style}
\usage{
styles_equity_cashflows(
  styles,
  config_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style identifiers, e.g.
\code{c("core", "core_plus", "value_added", "opportunistic")}.}

\item{config_dir}{Directory from which preset YAML files are loaded.
Defaults to the package \code{inst/extdata} folder.}
}
\value{
A tibble with columns:
\itemize{
\item \code{style} (character),
\item \code{year} (integer),
\item \code{equity_cf} (numeric), the leveraged equity cash flow in year
\code{year}.
}
}
\description{
This helper loads a set of preset styles from YAML, runs each configuration
through [\code{\link[=run_case]{run_case()}}] under the leveraged (debt) scenario, and extracts the
yearly equity cash flows. It is primarily used in vignettes and tests to
document the time profile of equity outflows and inflows by style.
}
\details{
For each style, the function:
\enumerate{
\item reads \code{preset_<style>.yml} from \code{config_dir};
\item calls [\code{\link[=run_case]{run_case()}}] and accesses \code{out$leveraged$cashflows};
\item returns the pair \code{(year, equity_cf)} with a style label.
}

The sign convention follows [\code{\link[=compute_leveraged_metrics]{compute_leveraged_metrics()}}]:
the initial equity outlay at \eqn{t = 0} is negative, subsequent net equity
distributions are positive when cash is returned to equity.
}
