% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_refi.R
\name{sweep_sensitivities}
\alias{sweep_sensitivities}
\title{Sensitivity grid (rate / exit yield) and monotonicity of ratios}
\usage{
sweep_sensitivities(
  dcf_res,
  rate_grid,
  exit_yield_grid,
  ltv = 0.6,
  maturity = 5L
)
}
\arguments{
\item{dcf_res}{list. Output of \code{\link[=dcf_calculate]{dcf_calculate()}}.}

\item{rate_grid}{numeric. Grid of annual nominal rates (decimal).}

\item{exit_yield_grid}{numeric. Grid of \code{exit_yield} values (decimal).}

\item{ltv}{numeric(1). Initial LTV (default 0.60).}

\item{maturity}{integer(1). Maturity (years) of the bullet schedule.}
}
\value{
tibble with columns \code{rate}, \code{exit_yield}, \code{min_dscr}, \code{max_ltv_forward}.
}
\description{
For each (\code{rate}, \code{exit_yield}) pair, builds a bullet schedule, merges it
with \code{\link[=dcf_calculate]{dcf_calculate()}} cash flows, computes ratios via \code{\link[=add_credit_ratios]{add_credit_ratios()}},
and returns \code{min_dscr} (t >= 1) and \code{max_ltv_forward} (t >= 1).
}
