% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataMixture-class}
\alias{DataMixture-class}
\alias{.DataMixture}
\alias{DataMixture}
\alias{.DefaultDataMixture}
\title{\code{DataMixture}}
\usage{
DataMixture(xshare = numeric(), yshare = integer(), ...)

.DefaultDataMixture()
}
\arguments{
\item{xshare}{(\code{numeric})\cr the doses for the share patients.}

\item{yshare}{(\code{integer})\cr the vector of toxicity events (0 or 1)
for the share patients. You can also supply \code{numeric} vectors,
but these will then be converted to \code{integer} internally.}

\item{...}{parameters passed to \code{\link[=Data]{Data()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{DataMixture}} is a class for the data with mixture sharing.
It inherits from \code{\link{Data}} and it contains additional information
on the mixture sharing.
}
\section{Slots}{

\describe{
\item{\code{xshare}}{(\code{numeric})\cr the doses for the share patients.}

\item{\code{yshare}}{(\code{integer})\cr the vector of toxicity events (0 or 1)
for the share patients.}

\item{\code{nObsshare}}{(\code{count})\cr number of share patients.}
}}

\note{
Typically, end users will not use the \code{.DefaultDataMixture()} function.
}
\examples{
my_data <- DataMixture(
  xshare = c(12, 14, 16, 18.0),
  yshare = c(0L, 1L, 1L, 1L),
  nObsshare = 4L,
  x = c(0.1, 0.5, 1.5),
  y = c(0, 0, 0),
  ID = 1:3,
  cohort = 1:3,
  doseGrid = c(0.1, 0.5, 1.5, 3, 6, seq(from = 10, to = 80, by = 2))
)
my_data
}
